/** @file   ParticleGunFlames.h
 * @brief   Declaration of ParticleGunFlames - class.
 * @version $Revision: 1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_ENG2D_ParticleGunFlames_H
#define H_ENG2D_ParticleGunFlames_H

#include "eng2d_dll.h"
#include "particlesystem.h"

namespace eng2d {


class GunFlameParticle : public Particle
{
public:
  GunFlameParticle();
  virtual ~GunFlameParticle();
  virtual void redraw( BITMAP* aCanvas, const Vec2D& aOffset ) const;
};

/** @class  ParticleGunFlames
 * @brief   Reprensents a particle effect of shooting flames from weapons
 *          nose.
 * @author  Tomi Lamminsaari
 *
 */
class DLLIMPORT ParticleGunFlames : public ParticleSystem
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================

  /** The average time the particles will live. */
  static int s_averageLifetime;

  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   */
	ParticleGunFlames( const Vec2D& aPos, const Vec2D& aDir, int aNum,
                     int aDistribution );

	/** Destructor
   */
	virtual ~ParticleGunFlames();

private:
  ParticleGunFlames( const ParticleGunFlames& rO );
  ParticleGunFlames& operator = ( const ParticleGunFlames& rO );
public:
};

};  // end of namespace

#endif
